global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob_6_5Prop")
local handlestate

handlestate = 0

-- locking down mechanism

global function AnimDone()
	local anim
	local ce9 = FindNodeByName("ce9")
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_P06_Lock_Down_Anim_Panel06_Lock_Down_Handle_Idle_6OC")	
	else
		anim = FindNodeByShortName("EM_ANIMATOR_P06_Lock_Down_Anim_Panel06_Lock_Down_Handle_Idle_12OC")
		ce9:Trigger()
	end

	prop:PlayAnim(anim, 1, 0)
	controls.script.TurnOnInterface()
	--Locking down mech
	controls.script.InteractDone()
end

global function PlayUp()
	local anim = FindNodeByShortName("EM_ANIMATOR_P06_Lock_Down_Anim_Panel06_Lock_Down_Handle_Turn_ClockWise")

	handlestate = 1
		
	FindNodeByName("Ob6_5SoundUp"):Trigger()

	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function PlayDown()
	local anim = FindNodeByShortName("EM_ANIMATOR_P06_Lock_Down_Anim_Panel06_Lock_Down_Handle_Turn_AntiClockWise")

	handlestate = 0
	
	FindNodeByName("Ob6_5SoundDown"):Trigger()

	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")

	controls.script.TurnOffInterface()

	if (handlestate == 0) then
		PlayUp()
	else
		PlayDown()
	end

	FindNodeByName("Console6InteractableScript").script.Object5State = handlestate

	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text -  locks down mech
			doctor::SID_2456:Locking Down Mechanism: A handbrake to stop the TARDIS travelling in physical space. Don't forget the Time handbrake too, or she'll drift off in time.
		else
			--VO Console Control Text - locks down mech
			amy::SID_2457:The Doctor always uses this after we've stopped. There's a time handbrake, maybe this is the normal handbrake?
		end
	end
end

global function DummyCallback()
end

global function ResetControl()
	local anim

	if handlestate == 0 then
		anim = FindNodeByShortName("EM_ANIMATOR_P06_Lock_Down_Anim_Panel06_Lock_Down_Handle_Idle_6OC")
	else
		anim = FindNodeByShortName("EM_ANIMATOR_P06_Lock_Down_Anim_Panel06_Lock_Down_Handle_Turn_AntiClockWise")
	end

	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0)
	handlestate = 0
end
